Attribute VB_Name = "mdDrawRadialDimension"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function DrawRadialDimension(Design, drawdoc, graph)

'Get the ProDESKTOP Application object
GetApplicationObject

'Get the Drawing Object pointer
Dim draw As aDrawing
Set draw = drawdoc.GetDrawing

Dim ddetail As aDesignDetail
Set ddetail = draw.GetDetail(Design, False)

'Get the paper geometry corresponding to the first selected item
Dim geom1 As zGeometry
Set geom1 = drawdoc.GetPaperGeometry(graph)
Dim original As zGeometry
Set original = geom1.GetOriginal

'Get the design instance
Dim view1 As aHiddenLine
Set view1 = geom1.GetInstance

Dim dimension As aDimension
Set dimension = app.GetClass("Dimension").CreateDimension(ddetail, 2, original)
    
'Set the position for the dimension line
Dim position As zVector
Set position = app.GetClass("Vector").CreateVector(0.001, 0.001, 0)
    
'Create the radial dimension line
'Dim RadDim As Object
Dim RadDim As aRadialDimLine
Set RadDim = app.GetClass("RadialDimLine").CreateRadialDimLine(position, dimension, view1)

Dim dimline As aDimLine
Set dimline = RadDim

Dim dimlinecenter As zVector
Set dimlinecenter = dimline.GetCenter()

Dim dimlinepos As zVector
Set dimlinepos = app.GetClass("Vector").CreateVector(0.1, 0.1, 0.1)
dimline.SetPosition dimlinepos
Set dimlinepos = dimline.GetPosition()

Dim calloutgroup As ObjectSet
Set calloutgroup = dimline.GetCalloutGroups()
Dim calloutgroupcount As Integer
calloutgroupcount = calloutgroup.GetCount()

Dim leaders As ObjectSet
Set leaders = dimline.GetLeaders()
Dim leaderscount As Integer
leaderscount = leaders.GetCount()

Dim def As aDimension
Set def = dimline.GetDefinition()

Dim tolerance As aDimTol
Set tolerance = app.GetClass("DimTol").CreateDimTol(ddetail, dimension)
Dim Callout As aCallout
Set Callout = app.GetClass("DimensionCallout").CreateDimensionCallout(tolerance)
Dim text As aDimLineText
Dim vector As zVector
Set text = app.GetClass("DimLineText").CreateDimLineText(RadDim, Callout, position, 0.0035)

'1 is for the topCenter
text.SetControlPoint 1, position
   
'Add the dimension line to the drawing.
draw.AddDimLine RadDim

'Add CenterLine
'To be done



End Function
